/*******************************************************
Filename		:  	DW_station_count.sql
Release 		:  	STORET c2.0, C2.0.1
SIR			:  	1371, 1501, 1560
Description		:  	Displays a summary of the selection parameters chosen on 
				the Station Selection Criteria page and shows a count of the 
				number of Stations that match the criteria.  Also provides the
				user with a series of checkboxes for selecting the data elements 
				to be included in their report.
Author			:  	Joseph Wilson
Date			: 	March 3, 2003 -- increased size of v_char_list from 500 to 2000
                  	:     	April 30, 2003 Pass '6' to footer routine to be used as a bookmark for the Help. - W Nash sir 1459  
				June  10, 2003 -- removed report element RF3 River Reach
				June 23, 2003 -- made report elements dynamic and added element grouping capabiliites -JW
				July 8, 2003 -- combined with result report elements table, updated table alias, added defaults -JW
                        	7/29/2003 SIR 1501-- Changed to show ALL stations when ALL states/counties or ALL HUCs is selected. -C Tsang
				08/14/2003 - Added Hyperlink to HELP logic. -WN
                        	08/15/2003 - Removed 'BETA' from the page title. Added commas to station count display. -CT
				08/22/2003 - Added report size limit of 40,000 -JW
				08/26/2003 - Changed Lat-Long labels on selection summary -JW
				11/07/2003 - Made report limit size message dynamic -JW
				06/18/2004 - Added support for retreival by Station ID.  Changed name of old D_ORG_LIST var to D_ORG_LIST2 -JW
				06/21/2004 - Corrected ORGANIZATION_NAME column ambiguity problem; increase sql var sizes -JW
				07/30/2004 - Increase SQL var sizes -JW
Comments		:  	The FROM and WHERE SQL clauses created by this procedure are passed to
				the report creation procedures so that the logic is not repeated
				and the parameters are only passed once.  Station list functionality disabled 12/4.
**********************************************************/

SET DEF OFF;

CREATE OR REPLACE PROCEDURE DW_STATION_COUNT (
geographic 		char default NULL,
as_state 		number default 0,
as_county 		char default 'ALL',
v_county_code 		char default 'ALL',
MAX_LAT_DD 		number default 90,
dir_maxlat 		char default NULL,
MIN_LONG_DD 		number default 180,
dir_minlong		char default NULL,
MAX_LONG_DD 		number default 0,
dir_maxlong		char default NULL,
MIN_LAT_DD 		number default 0,
dir_minlat 		char default NULL,
as_huc 			char default 'ALL',
D_STYPE_LIST 		owa_util.ident_arr default DW_glob_var.empty,
--characteristic 		char,
v_char_names		char,
as_char 		char,
char_list		owa_util.ident_arr,
AS_CHAR_ALIAS_TYPE	number,
taxon_filter 		char,
d_org_list		number default 0,
d_org_list2		owa_util.ident_arr default DW_glob_var.empty,
V_STATION_NAMES		char default NULL,
AS_STATION		char default 'dummy',
station_list		owa_util.ident_arr default DW_glob_var.empty,
as_extref		char default NULL,
d_extref_list		number default 0,
searchtype		char default NULL
) 

AS
v_CursorID		INTEGER;
v_SelectStmt		VARCHAR2(1000);
v_FromStmt		VARCHAR2(1000);
v_WhereStmt		VARCHAR2(32000);
v_SQLStmt		VARCHAR2(32000);
v_Dummy			INTEGER;
v_StationCount		NUMBER;
v_stype_list		VARCHAR2(500);
v_StateName		varchar2(40);
v_stype_name_list 	varchar2(1000);
v_stype_name		varchar2(100);
v_char_list		varchar2(500);
v_station_list		varchar2(2000);
v_org_list		varchar2(500);
v_org_id		varchar2(100);
v_org_id_list		varchar2(500);
v_begin_date		date;
v_end_date		date;
v_char_flag		BOOLEAN := FALSE;
-- ignore negative values on lat/long
v_maxlat		number := ABS(max_lat_dd);
v_minlat		number := ABS(min_lat_dd);
v_maxlong		number := ABS(max_long_dd);
v_minlong		number := ABS(min_long_dd);
v_STN_org_id		FA_STATION.ORGANIZATION_ID%TYPE;
v_STN_id		FA_STATION.STATION_ID%TYPE;
v_max_report_size	number:= 40000;

program_path  		varchar2(1000) := null;
script_path   		varchar2(1000) := null;
image_path    		varchar2(1000) := null;
page_title    		varchar2(100)  :='Station Search Summary';

help_file         varchar2(100);

v_num_repElement 	number;
v_repElement_count	number :=0;
CURSOR cRepElement IS
	SELECT DISTINCT ELEMENT_NAME, STN_REPORT_NUMBER, STN_ELEMENT_DEFAULT, HELP_LINK
	FROM APP_COLUMN_NAME
	where STN_REPORT_NUMBER IS NOT NULL
	order by STN_REPORT_NUMBER;

BEGIN
v_SelectStmt := 'SELECT count(distinct(FA.pk_isn)) INTO :StationCount';
v_FromStmt := 'FROM FA_STATION FA';
v_WhereStmt := ' WHERE 1=1';

--Generate WHERE statement based on geographic search type
IF geographic = 'StateCounty' THEN
	IF as_state <> 0 THEN
		SELECT state_name into v_StateName
  			From di_geo_state
  			where pk_isn = as_state;
		IF v_County_Code <> 'ALL' THEN
			v_WhereStmt:= 'Where FA.fk_geo_county IN ('||v_County_Code||')';
		ELSE
			v_WhereStmt:= 'Where FA.fk_geo_state = '||as_state;
		END IF;
--	ELSE
--		v_WhereStmt:= 'Where FA.fk_geo_state IS NOT NULL';
	END IF;
ELSIF geographic = 'HUC' THEN
	IF as_huc <> 'ALL' THEN
		v_WhereStmt:= 'Where FA.hydrologic_unit_code = '||as_huc;
--	ELSE
--		v_WhereStmt:= 'Where FA.hydrologic_unit_code IS NOT NULL';
	END IF; 
ELSIF geographic = 'LatLong' THEN
	IF MAX_LAT_DD = 90 AND MIN_LONG_DD = 180 AND MAX_LONG_DD = 0 AND MIN_LAT_DD = 0 THEN
--		v_WhereStmt:= 'Where latitude IS NOT NULL and longitude IS NOT NULL';
            null;
 	ELSE
		IF dir_maxlong = 'WEST' THEN
			v_maxlong := -1 * v_maxlong;
		END IF;
		IF dir_minlong = 'WEST' THEN
			v_minlong := -1 * v_minlong;
		END IF;
		IF dir_maxlat = 'SOUTH' THEN
			v_maxlat := -1 * v_maxlat;
		END IF;
		IF dir_minlat = 'SOUTH' THEN
			v_minlat := -1 * v_minlat;
		END IF;
		v_WhereStmt:= 'Where latitude <= '||v_maxlat||' AND latitude >='||v_minlat||' AND 
			longitude <= '||v_maxlong||' AND longitude >= '||v_minlong;
	END IF; 
END IF;

--Process station type list and add to WHERE statement if filtering
IF D_STYPE_LIST(1) <> 'ALL' THEN
	FOR i IN 1 .. d_stype_list.LAST LOOP
		v_stype_list := v_stype_list||d_stype_list(i)||',';
		SELECT primary_type||'-'||secondary_type INTO v_stype_name
			FROM DI_STATN_TYPES
			WHERE PK_ISN = d_stype_list(i);
		v_stype_name_list := v_stype_name_list||v_stype_name||'<br>';
	END LOOP;  
	v_stype_list := RTRIM(v_stype_list,',');
	v_WhereStmt := v_WhereStmt||' AND fk_statn_types IN ('||v_stype_list||')';
ELSE
	v_stype_name_list := 'ALL';
END IF;

--Process characteristic list and add to WHERE statement if filtering. Loop starts at 2 to
--ignore dummy value that is passed. Dummy is used to maintain column width.
IF char_list.LAST > 1 THEN
	FOR i IN 2 .. char_list.LAST LOOP
		v_char_list := v_char_list||char_list(i)||',';
	END LOOP;  
	v_char_list := RTRIM(v_char_list,',');
	v_FromStmt := v_FromStmt||',STATION_CHAR';
	v_WhereStmt := v_WhereStmt||' AND fk_fa_statn = FA.pk_isn AND fk_char IN ('||v_char_list||')';
	v_Char_Flag := TRUE;
END IF;

--Process organization type list and add to WHERE statement if filtering
IF D_ORG_LIST2(1) <> 'ALL' THEN
	FOR i IN 1 .. d_org_list2.LAST LOOP
		v_org_list := v_org_list||d_org_list2(i)||',';
		SELECT organization_id INTO v_org_id
			FROM DI_ORG
			WHERE PK_ISN = d_org_list2(i);
		v_org_id_list := v_org_id_list||v_org_id||'<br>';
	END LOOP;  
	v_org_list := RTRIM(v_org_list,',');
	v_WhereStmt := v_WhereStmt||' AND fk_org IN ('||v_org_list||')';
ELSE
	v_org_id_list := 'ALL';
END IF;

--Process Station list and add to WHERE statement if filtering. Loop starts at 2 to
--ignore dummy value that is passed. Dummy is used to maintain column width.
IF station_list.LAST > 1 THEN
	FOR i IN 2 .. station_list.LAST LOOP
		v_station_list := v_station_list||station_list(i)||',';
		SELECT organization_id, station_id INTO v_STN_org_id, v_STN_id
			FROM FA_STATION
			WHERE pk_isn = station_list(i);
		IF i = 2 THEN
			v_WhereStmt := v_WhereStmt||' AND (fa.organization_id='''||v_STN_org_id||''' AND fa.station_id ='''||v_STN_id||'''';
		ELSIF i > 2 THEN
			v_WhereStmt := v_WhereStmt||' OR fa.organization_id='''||v_STN_org_id||''' AND fa.station_id ='''||v_STN_id||'''';
		END IF;
	END LOOP;
	v_WhereStmt := v_WhereStmt||')';
	v_station_list := RTRIM(v_station_list,',');
END IF;

IF D_ORG_LIST <> 0 AND (station_list.LAST <= 1 OR station_list.count = 0) THEN
	V_ORG_LIST := D_ORG_LIST;
	SELECT organization_id INTO v_org_id
			FROM DI_ORG
			WHERE PK_ISN = d_org_list;
	v_org_id_list := v_org_id||'<br>';
	v_WhereStmt := v_WhereStmt||' AND fk_org IN ('||v_org_list||')';
END IF;

--Assemble sql statement
v_SQLStmt := 'BEGIN '||v_SelectStmt||' '||v_FromStmt||' '||v_WhereStmt||' AND FA.location_point_type = ''*POINT OF RECORD'';END;';

--Process SQL statement and capture count value
v_CursorID := DBMS_SQL.OPEN_CURSOR;
DBMS_SQL.PARSE(v_CursorID, v_SQLStmt, DBMS_SQL.NATIVE);
DBMS_SQL.BIND_VARIABLE(v_CursorID, ':StationCount', v_StationCount);
v_Dummy := DBMS_SQL.EXECUTE(v_CursorID);
DBMS_SQL.VARIABLE_VALUE(v_CursorID, ':StationCount', v_StationCount);
DBMS_SQL.CLOSE_CURSOR(v_CursorID);

--Generate HTML page

DW_TOP_OF_PAGE(page_title, program_path, script_path, image_path);
htp.print('<br><center><h4>Number of Stations Returned: '||TO_CHAR(v_StationCount,'999,999,999')||'</h4></center><table cols=1 border=1 width=500 align="CENTER"><tr><td><table cols=2 width="100%" cellspacing=10>');
htp.print( '<tr><td colspan=2 align="center"><b>Search Parameter Values</b></td></tr>' );

--Display geographic search parameteres based on the selected search option
IF geographic = 'StateCounty' THEN
	IF as_state <> 0 THEN
		IF v_County_Code <> 'ALL' THEN
			htp.print( '<tr><td width="50%" align="right"><b>State: </td><td> '||v_StateName||'</b></td></tr>' );
			htp.print( '<tr><td align="right"><b>County: </td><td> '||as_county||'</b></td></tr>' );
		ELSE
			htp.print( '<tr><td width="50%" align="right"><b>State: </td><td> '||v_StateName||'</b></td></tr>' );
			htp.print( '<tr><td align="right"><b>County: </td><td> ALL</b></td></tr>' );
		END IF;
	ELSE
		htp.print( '<tr><td width="50%" align="right"><b>State: </td><td> ALL</b></td></tr>' );
		htp.print( '<tr><td align="right"><b>County: </td><td> ALL</b></td></tr>' );
	END IF;
ELSIF geographic = 'HUC' THEN
	IF as_huc IS NOT NULL THEN
		htp.print( '<tr><td width="50%" align="right"><b>HUC: </td><td> '||as_huc||'</b></td></tr>' );
	ELSE
		htp.print( '<tr><td width="50%" align="right"><b>HUC: </td><td> ALL</b></td></tr>' );
	END IF; 
ELSIF geographic = 'LatLong' THEN
	IF MAX_LAT_DD = 90 AND MIN_LONG_DD = -180 AND MAX_LONG_DD = 0 AND MIN_LAT_DD = 0 THEN
		htp.print( '<tr><td width="50%" align="right"><b>Latitude/Longitude: </td><td> ALL</b></td></tr>' );
	ELSE
		htp.print( '<tr><td width="50%" align="right"><b>North Limit: </td><td> '||MAX_LAT_DD||' '||dir_maxlat||'</b></td></tr>' );
		htp.print( '<tr><td width="50%" align="right"><b>South Limit: </td><td> '||MIN_LAT_DD||' '||dir_minlat||'</b></td></tr>' );
		htp.print( '<tr><td width="50%" align="right"><b>East Limit: </td><td> '||MAX_LONG_DD||' '||dir_maxlong||'</b></td></tr>' );
		htp.print( '<tr><td width="50%" align="right"><b>West Limit: </td><td> '||MIN_LONG_DD||' '||dir_minlong||'</b></td></tr>' );
	END IF; 
END IF;

IF TRIM(v_station_names) IS NOT NULL THEN
  htp.print( '<tr><td width="50%" align="right" valign="top"><b>Station(s): </td><td> '||v_station_names||'</b></td></tr>');
END IF;

htp.print( '<tr><td width="50%" align="right" valign="top"><b>Station Type(s): </td><td> '||v_STYPE_Name_LIST||'</b></td></tr>' );

IF TRIM(v_char_names) IS NULL THEN
  htp.print( '<tr><td align="right" valign="top"><b>Characteristic(s): </td><td> ALL</b></td></tr>');
ELSE
  htp.print( '<tr><td align="right" valign="top"><b>Characteristic(s): </td><td> '||v_char_names||'</b></td></tr>');
END IF;

IF v_station_names IS NULL THEN
	htp.print( '<tr><td align="right" valign="top"><b>Organization(s): </td><td> '||v_org_id_list||'</b></td></tr>');
END IF;

htp.print('</table></td></tr></table>');

--htp.print( '<br><br><b>'||v_SQLStmt||'<br><br></b>');
--Display report choices and report column select boxes
IF v_StationCount = 0 THEN
	htp.print('<br><center> No Stations match your search criteria. Please select ''Back'' to modify your search.
	<form><input type="button" value="  <<Back  " width=40 onClick=Close_Onclick();></form></center>
');
ELSIF v_StationCount > v_max_report_size THEN
	htp.print('<br><center> The number of Stations that match your search criteria has exceeded the <BR> allowable
Station Report size limit of '||TO_CHAR(v_max_report_size,'999,999,999')||'.  Please select ''Back'' to modify your search.
	<form><input type="button" value="  <<Back  " width=40 onClick=Close_Onclick();></form></center>
');
ELSE
	htp.print('<br><center> Select ''Back'' to modify search parameters and refine your query. <BR>Select ''Continue'' to generate
a report based on your current selections. <BR>You may customize the content of your report by selecting Data Elements below.</center>');
htp.print('<br><form action="DW_STATION_HUB_custom" method=POST>
<input type="hidden" name="v_FromStmt" value="'||v_FromStmt||'">
<input type="hidden" name="v_WhereStmt" value="'||v_WhereStmt||'">
<input type="hidden" name="v_StationCount" value="'||v_StationCount||'">
<table cols=2 cellspacing=10 align="center" width=500><tr><td width=250>
<center><input type="button" value="  <<Back  " width=40 onClick=Close_Onclick();></center></td><td>
<left><input type="button" value="Continue>>" onClick=submitReport();><left></td></tr>
<!--
<tr><td></td><td>
<input type="radio" checked name="report_type" value="CUSTOM">Download Report <br>
<input type="radio" name="report_type" value="LIST">View Station List
</td></tr>
-->
</table>

<table width=500 cols=1 border=1 align="center"><tr><td><table cols=2 cellspacing="10">
<tr><td colspan=2><b><center>Select Data Elements for Report</center></b></td></tr>
<tr><td valign="top" width="50%">
');

SELECT COUNT(DISTINCT(STN_REPORT_NUMBER)) INTO v_num_repElement
	FROM APP_COLUMN_NAME
	WHERE STN_REPORT_NUMBER IS NOT NULL;

FOR RepElement in cRepElement LOOP
	IF v_repElement_count >= v_num_repElement/2 THEN
		htp.print('</td><td valign="top">');
		v_repElement_count := 0;
	END IF;
	v_repElement_count := v_repElement_count +1;
	IF RepElement.STN_ELEMENT_DEFAULT = 'Y' THEN
		IF RepElement.HELP_LINK > 0 THEN
			help_file:=''''||DW_glob_var.lv_doc_path||'DW_storet_help.html#'||RepElement.HELP_LINK ||'''';
			htp.print('<input type="checkbox" name="v_Columns" CHECKED value="'||RepElement.stn_report_number||'">'||'<A HREF="javascript:openHelp('||help_file||')">'||RepElement.element_name||'</A>'||'<br>');
		ELSE
			htp.print('<input type="checkbox" name="v_Columns" CHECKED value="'||RepElement.stn_report_number||'">'||RepElement.element_name||'<br>');
		END IF;
	ELSE
		IF RepElement.HELP_LINK > 0 THEN
			help_file:=''''||DW_glob_var.lv_doc_path||'DW_storet_help.html#'||RepElement.HELP_LINK ||'''';
			htp.print('<input type="checkbox" name="v_Columns" value="'||RepElement.stn_report_number||'">'||'<A HREF="javascript:openHelp('||help_file||')">'||RepElement.element_name||'</A>'||'<br>');
		ELSE
			htp.print('<input type="checkbox" name="v_Columns" value="'||RepElement.stn_report_number||'">'||RepElement.element_name||'<br>');
		END IF;	
	END IF;
END LOOP;

htp.print('
</td></tr></table>
<center>
<input type="button" value="Select All" onClick=longReport();>
<input type="button" value="Clear All" onClick=clearReport();>
<input type="RESET" value="Restore Defaults">
</center>
</td></tr><br></table><br>
<table cols=2 cellspacing=10 align="center" width=500><tr><td width=250>
<center><input type="button" value="  <<Back  " width=40 onClick=Close_Onclick();></center></td><td>
<left><input type="button" value="Continue>>" onClick=submitReport();><left></td></tr></table>
</form>');
END IF;
DW_bottom_of_page(6);

END;
/
show errors;